﻿<%@ Page Language="VB" MasterPageFile="~/MasterPage.master" AutoEventWireup="false" CodeFile="Default.aspx.vb" Inherits="_Default" title="Baza Błędów - Raporty" %>
<asp:Content ID="Content1" ContentPlaceHolderID="plcTitle" Runat="Server">
  Baza Błędów - Raporty</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="plcMainContent" Runat="Server">
  Strona raportów podaje wyczerpujące informacje o błedach w systemie. Możesz szukać defektów wprowadzonych w określonym przedziale czasowym, dla określonej aplikacji lub dla jednej lub kilku jej funkcji.
  Możesz również filtrować listę błędów według zgłaszającego użytkownika, istotności, statusu i priorytetu. Aby wybrać kilka pozycji z listy, przytrzymaj klawisz Ctrl podczas wyboru.
  <br /><br />
  <asp:PlaceHolder ID="plcExpandCollapsePanel" runat="server" Visible="false" EnableViewState="false">
  <div id="expand" style="display: none;"><a href="#" onclick="ExpandCollapsePanel(false);"><img src="~/Images/Collapse.gif" runat="server" style="margin-right: 5px;" />Zmień kryteria wyszukiwania</a></div>
  <div id="collapse"><a href="#" onclick="ExpandCollapsePanel(true);"><img src="~/Images/Expand.gif" runat="server" style="margin-right: 5px;" />Zmień kryteria wyszukiwania</a></div>
  </asp:PlaceHolder>
  <div id="reportingSection" runat="server">
  <fieldset style="width: 450px;">
  <legend>Błędy zgłoszone w przedziale czasu</legend>
  <table style="width: 450px;" class="NonPrintable" border="0">
  <tr>
    <td colspan="2" class="Label">Od&nbsp;<asp:Label ID="lblStartDate" runat="server" /><br />
    </td>
    <td colspan="2" class="Label">Do&nbsp;<asp:Label ID="lblEndDate" runat="server" /><br />
    </td>
  </tr>
  <tr>
    <td>
      <asp:Calendar ID="calStartDate" runat="server" BackColor="White" BorderColor="#999999"
        CellPadding="4" DayNameFormat="Shortest" Font-Names="Verdana" Font-Size="8pt" ForeColor="Black"
        Height="1px" Width="89px">
        <SelectedDayStyle BackColor="#666666" Font-Bold="True" ForeColor="White" />
        <SelectorStyle BackColor="#CCCCCC" />
        <WeekendDayStyle BackColor="#FFFFCC" />
        <OtherMonthDayStyle ForeColor="#808080" />
        <TodayDayStyle BackColor="#CCCCCC" ForeColor="Black" />
        <NextPrevStyle VerticalAlign="Bottom" />
        <DayHeaderStyle BackColor="#CCCCCC" Font-Bold="True" Font-Size="7pt" />
        <TitleStyle BackColor="#999999" BorderColor="Black" Font-Bold="True" />
      </asp:Calendar>
     </td>
    <td style="vertical-align: bottom;">
      <asp:Button ID="btnClearStartDate" runat="server" Text="Wyczyść" /></td>
    <td>
      <asp:Calendar ID="calEndDate" runat="server" BackColor="White" BorderColor="#999999"
        CellPadding="4" DayNameFormat="Shortest" Font-Names="Verdana" Font-Size="8pt" ForeColor="Black"
        Height="1px" Width="13px">
        <SelectedDayStyle BackColor="#666666" Font-Bold="True" ForeColor="White" />
        <SelectorStyle BackColor="#CCCCCC" />
        <WeekendDayStyle BackColor="#FFFFCC" />
        <OtherMonthDayStyle ForeColor="Gray" />
        <TodayDayStyle BackColor="#CCCCCC" ForeColor="Black" />
        <NextPrevStyle VerticalAlign="Bottom" />
        <DayHeaderStyle BackColor="#CCCCCC" Font-Bold="True" Font-Size="7pt" />
        <TitleStyle BackColor="#999999" BorderColor="Black" Font-Bold="True" />
      </asp:Calendar>
     </td>
    <td style="vertical-align: bottom;">
      <asp:Button ID="btnClearEndDate" runat="server" Text="Wyczyść" />
     </td>
  </tr>
  </table>
  </fieldset>
  <br /><br />
  <fieldset style="width: 450px;margin-bottom: 20px;">
  <legend>Aplikacja i jej funkcje</legend>
  <table style="width: 450px;" class="NonPrintable" border="0">
  <tr>
    <td class="Label">
      Aplikacja 
    </td>
    <td class="Label">
    <asp:Label ID="lblFeature" runat="server" Text="Funkcja aplikacji" />
    </td>
  </tr>
  <tr>
    <td>
      <asp:DropDownList ID="lstApplications" runat="server" AppendDataBoundItems="True" AutoPostBack="True" DataSourceID="odsApplications" DataTextField="Description" DataValueField="Id">
      <asp:ListItem Value="">[Nie filtruj]</asp:ListItem>
      </asp:DropDownList></td>
    <td>
          <asp:ListBox ID="lstFeature" runat="server" DataTextField="Description" DataValueField="Id" DataSourceID="odsFeature" Rows="3" SelectionMode="Multiple" AppendDataBoundItems="True">
        <asp:ListItem Value="" Selected="True">[Nie filtruj]</asp:ListItem>
      </asp:ListBox>
     </td>
  </tr>
  </table>
  </fieldset>
  <br /><br />
  <fieldset style="width: 450px;margin-bottom: 20px;">
  <legend>Inne właściwości błędu</legend>
  <table style="width: 450px;" class="NonPrintable" border="0">
 <tr>
    <td class="Label">
      Zgłoszony przez</td>
    <td class="Label">
      Istotność</td>
  </tr>
  <tr>
    <td> <asp:ListBox ID="lstMember" runat="server" DataSourceID="odsMembers" DataTextField="UserName" DataValueField="ProviderUserKey" AppendDataBoundItems="True" SelectionMode="Multiple">
        <asp:ListItem Value="" Selected="True">[Nie filtruj]</asp:ListItem>
      </asp:ListBox>
    </td>
    <td>
      <asp:ListBox ID="lstSeverity" runat="server" DataSourceID="odsSeverity" DataTextField="Description" DataValueField="Id" AppendDataBoundItems="True" SelectionMode="Multiple">
        <asp:ListItem Value="" Selected="True">[Nie filtruj]</asp:ListItem>
      </asp:ListBox></td>
  </tr>
  <tr>
    <td colspan="2">&nbsp;</td>
  </tr>
  <tr>
   <td class="Label">
      Status</td>
    <td class="Label">
      Priorytet</td>
  </tr>
  <tr>
    <td>
      <asp:ListBox ID="lstStatus" runat="server" DataTextField="Description" DataValueField="Id" DataSourceID="odsStatus" AppendDataBoundItems="True" SelectionMode="Multiple">
        <asp:ListItem Value="" Selected="True">[Nie filtruj]</asp:ListItem>
      </asp:ListBox></td>
    <td>
      <asp:ListBox ID="lstPriority" runat="server" SelectionMode="Multiple">
        <asp:ListItem Value="" Selected="True">[Nie filtruj]</asp:ListItem>
        <asp:ListItem>1</asp:ListItem>
        <asp:ListItem>2</asp:ListItem>
        <asp:ListItem>3</asp:ListItem>
        <asp:ListItem>4</asp:ListItem>
        <asp:ListItem>5</asp:ListItem>
      </asp:ListBox></td>
    </tr>
    <tr>
      <td colspan="2">&nbsp;</td>
    </tr>
  </table>
  </fieldset>
  </div>
  <br />
  <asp:Button ID="btnReport" runat="server" Text="Raport" />
  <br /><br />
  <asp:GridView ID="GridView1" runat="server" AllowPaging="True" AllowSorting="True" AutoGenerateColumns="False" DataKeyNames="Id" Visible="False" Width="928px" PageSize="3">
    <Columns>
      <asp:BoundField DataField="Id" HeaderText="Id" SortExpression="Id" >
        <ItemStyle Width="50px" />
      </asp:BoundField>
      <asp:HyperLinkField DataNavigateUrlFields="Id" DataTextField="Title" HeaderText="Nazwa" SortExpression="Title"
        DataNavigateUrlFormatString="~/Bugs/ViewBug.aspx?ID={0}">
        <ItemStyle Width="273" />
      </asp:HyperLinkField>
      <asp:BoundField DataField="CreatedDateAndTime" HeaderText="Data zgłoszenia" SortExpression="CreatedDateAndTime" >
        <ItemStyle Width="160px" />
      </asp:BoundField>
      <asp:TemplateField HeaderText="Funkcja" SortExpression="Feature">
        <ItemTemplate>
          <asp:Label ID="Label1" runat="server" Text='<%# Eval("Feature.Name") %>' />
        </ItemTemplate>
        <ItemStyle Width="130px" />
      </asp:TemplateField>
      <asp:TemplateField HeaderText="Status" SortExpression="Status">
      <ItemTemplate>
        <asp:Label ID="Label2" runat="server" Text='<%# Eval("Status.Name") %>' />
      </ItemTemplate>
      <ItemStyle Width="110px" />
      </asp:TemplateField>
      <asp:TemplateField HeaderText="Aplikacja" SortExpression="Application">
      <ItemTemplate>
        <asp:Label ID="Label2" runat="server" Text='<%# Eval("Application.Name") %>' />
      </ItemTemplate>
      <ItemStyle Width="130px" />
      </asp:TemplateField>
      <asp:TemplateField HeaderText="Edycja">
      <ItemTemplate>
        <asp:HyperLink ID="test" runat="server" NavigateUrl='<%# "~/Bugs/AddEditBug.aspx?Id=" & Eval("Id") & "&amp;ApplicationId=" & Eval("Application.Value") %>'>Edytuj</asp:HyperLink>
      </ItemTemplate>
      <ItemStyle Width="75px" />
      </asp:TemplateField>
    </Columns>
  </asp:GridView>
  <asp:Label ID="lblNumRecords" runat="server" EnableViewState="false" />&nbsp;<br />
  <asp:ObjectDataSource ID="odsApplications" runat="server" SelectMethod="GetApplicationItems"
    TypeName="ListManager"></asp:ObjectDataSource>
  <asp:ObjectDataSource ID="odsSeverity" runat="server" SelectMethod="GetSeverityItems"
    TypeName="ListManager"></asp:ObjectDataSource>
  <asp:ObjectDataSource ID="odsFeature" runat="server" SelectMethod="GetFeatureItems" TypeName="ListManager">
    <SelectParameters>
      <asp:ControlParameter ControlID="lstApplications" DefaultValue="-1" Name="applicationId"
        PropertyName="SelectedValue" Type="Int32" />
    </SelectParameters>
  </asp:ObjectDataSource>
  <asp:ObjectDataSource ID="odsMembers" runat="server" SelectMethod="GetAllUsers" TypeName="System.Web.Security.Membership">
  </asp:ObjectDataSource>
  <asp:ObjectDataSource ID="odsStatus" runat="server" SelectMethod="GetStatusItems" TypeName="ListManager"></asp:ObjectDataSource>
  <asp:ObjectDataSource ID="odsBugList" runat="server" SelectMethod="GetBugList" SortParameterName="sortExpression"
    TypeName="BugManager" EnableViewState="False">
    <SelectParameters>
      <asp:Parameter Name="sortExpression" Type="String" />
      <asp:Parameter Name="searchCriteria" />
    </SelectParameters>
  </asp:ObjectDataSource>
</asp:Content>

